package com.ejie.ab18a.properties;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;


import com.ejie.ab18a.log.Ab18aLog;

/**
 * Clase que mantiene una hash de ficheros de configuracion. Es un patr�n
 * singleton que carga las propiedad en el primer acceso
 * 
 * @author XXXX
 */

public final class Ab18aPropertiesBatchManager {

	// Referencia a si mismo por tratarse de un singletton
	private static Ab18aPropertiesBatchManager instance;

	// Fichero de configuracion principal de la aplicacion
	private static final String APP_PROPERTIES = "/config/ab18a/ab18aBatch.properties";

	// Hashtable donde se almacenan los ficheros de propiedades
	private static Properties properties;

	public static String getProperty(String propiedad) throws RuntimeException {
	String strResultado = "";
    FileInputStream f = null;
    try{
          //TODO LOCAL 
    		//f = new FileInputStream("/config/dominio_desa/ab18a/ab18aBatch.properties");
    		f = new FileInputStream("/config/ab18a/ab18aBatch.properties");
    }catch(Exception e){
          throw new RuntimeException("obtenerProperty(). No se ha encontrado el fichero ab18a/ab18aBatch.properties.");                                  
    }
    if(null!= f) {
          //Existe el fichero de propiedades
          Properties prop = new Properties();
          try{
                prop.load(f);

                //Obtener propiedad
                strResultado = prop.getProperty(propiedad);
          }catch (IOException e) {
                throw new RuntimeException("obtenerProperty(). No es posible obtener la propiedad "+propiedad);                                 
          }
    }
    return strResultado;
}

}
